# Copyright (C) 2013-2020 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 23-Apr-2020 17:07.

"""FmkError userdefined datapoint type, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4.  """


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class FmkError(izot.resources.base.Structure):
    """FmkError userdefined datapoint type.  This file is Echelon's
    manufacturer-specific FPT file, containing User Functional Profile
    Templates."""

    def __init__(self):
        super().__init__(
            key=4,
            scope=4
        )

        self.___bf00 = izot.resources.base.Scaled(
            size=1,
            signed=False
        )
        self._register(('___bf00', self.___bf00))

        self.___bf01 = izot.resources.base.Scaled(
            size=1,
            signed=False
        )
        self._register(('___bf01', self.___bf01))
        self._original_name = 'UNVT_FmkError'
        self._definition = userdefined.add(self)

    def __set_adcerr_flag(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=0
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_adcerr_flag(self):
        return self.___bf00._getbits(
            size=1,
            offset=0,
            signed=False
        )

    adcerr_flag = property(
        __get_adcerr_flag,
        __set_adcerr_flag,
        None,
        """Bitfield adcerr_flag"""
    )

    def __set_wrongs_flag(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=1
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_wrongs_flag(self):
        return self.___bf00._getbits(
            size=1,
            offset=1,
            signed=False
        )

    wrongs_flag = property(
        __get_wrongs_flag,
        __set_wrongs_flag,
        None,
        """Bitfield wrongs_flag"""
    )

    def __set_nosens_flag(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=2
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_nosens_flag(self):
        return self.___bf00._getbits(
            size=1,
            offset=2,
            signed=False
        )

    nosens_flag = property(
        __get_nosens_flag,
        __set_nosens_flag,
        None,
        """Bitfield nosens_flag"""
    )

    def __set_badsen_flag(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=3
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_badsen_flag(self):
        return self.___bf00._getbits(
            size=1,
            offset=3,
            signed=False
        )

    badsen_flag = property(
        __get_badsen_flag,
        __set_badsen_flag,
        None,
        """Bitfield badsen_flag"""
    )

    def __set_lowflo_flag(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=4
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_lowflo_flag(self):
        return self.___bf00._getbits(
            size=1,
            offset=4,
            signed=False
        )

    lowflo_flag = property(
        __get_lowflo_flag,
        __set_lowflo_flag,
        None,
        """Bitfield lowflo_flag"""
    )

    def __set_noheat_flag(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=5
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_noheat_flag(self):
        return self.___bf00._getbits(
            size=1,
            offset=5,
            signed=False
        )

    noheat_flag = property(
        __get_noheat_flag,
        __set_noheat_flag,
        None,
        """Bitfield noheat_flag"""
    )

    def __set_bit9(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=6
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit9(self):
        return self.___bf00._getbits(
            size=1,
            offset=6,
            signed=False
        )

    bit9 = property(
        __get_bit9,
        __set_bit9,
        None,
        """Bitfield bit9"""
    )

    def __set_bit8(self, v):
        if 0 <= v <= 1:
            self.___bf00._setbits(
                value=v,
                size=1,
                offset=7
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit8(self):
        return self.___bf00._getbits(
            size=1,
            offset=7,
            signed=False
        )

    bit8 = property(
        __get_bit8,
        __set_bit8,
        None,
        """Bitfield bit8"""
    )

    def __set_chksen_flag(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=0
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_chksen_flag(self):
        return self.___bf01._getbits(
            size=1,
            offset=0,
            signed=False
        )

    chksen_flag = property(
        __get_chksen_flag,
        __set_chksen_flag,
        None,
        """Bitfield chksen_flag"""
    )

    def __set_lozero_flag(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=1
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_lozero_flag(self):
        return self.___bf01._getbits(
            size=1,
            offset=1,
            signed=False
        )

    lozero_flag = property(
        __get_lozero_flag,
        __set_lozero_flag,
        None,
        """Bitfield lozero_flag"""
    )

    def __set_bit5(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=2
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit5(self):
        return self.___bf01._getbits(
            size=1,
            offset=2,
            signed=False
        )

    bit5 = property(
        __get_bit5,
        __set_bit5,
        None,
        """Bitfield bit5"""
    )

    def __set_bit4(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=3
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit4(self):
        return self.___bf01._getbits(
            size=1,
            offset=3,
            signed=False
        )

    bit4 = property(
        __get_bit4,
        __set_bit4,
        None,
        """Bitfield bit4"""
    )

    def __set_bit3(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=4
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit3(self):
        return self.___bf01._getbits(
            size=1,
            offset=4,
            signed=False
        )

    bit3 = property(
        __get_bit3,
        __set_bit3,
        None,
        """Bitfield bit3"""
    )

    def __set_bit2(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=5
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit2(self):
        return self.___bf01._getbits(
            size=1,
            offset=5,
            signed=False
        )

    bit2 = property(
        __get_bit2,
        __set_bit2,
        None,
        """Bitfield bit2"""
    )

    def __set_bit1(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=6
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_bit1(self):
        return self.___bf01._getbits(
            size=1,
            offset=6,
            signed=False
        )

    bit1 = property(
        __get_bit1,
        __set_bit1,
        None,
        """Bitfield bit1"""
    )

    def __set_warmup_flag(self, v):
        if 0 <= v <= 1:
            self.___bf01._setbits(
                value=v,
                size=1,
                offset=7
            )
        else:
            raise ValueError('Not in range 0..1')

    def __get_warmup_flag(self):
        return self.___bf01._getbits(
            size=1,
            offset=7,
            signed=False
        )

    warmup_flag = property(
        __get_warmup_flag,
        __set_warmup_flag,
        None,
        """Bitfield warmup_flag"""
    )


    def __len__(self):
        """Return the length of the type, in bytes."""
        return 2


if __name__ == '__main__':
    # unit test code.
    item = FmkError()
    pass
